/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

// This header should be included by each OS specific source (.cpp) file.

#ifndef AGTPCIEOSPORT_H
#define AGTPCIEOSPORT_H

#define INVALID_SIZE      0
#define INVALID_ADDRESS   0xffffffff
#define INVALID_OSHANDLE  0

// This class must be implemented for each supported OS in an OS specific source file.
class CAgtOSPort
{
public:
  // Connection handling with driver
  static void OSDeviceIdGet( UInt16 vendId, UInt16 devId, UInt16 index, UInt32* deviceId );
  static void OSOpenPort( UInt32 DeviceId, HANDLE &myOSHandle, AgtPortHandleT *portHandle );
  static void OSClosePort( HANDLE myOSHandle );

  // Direct config access without using PCI API protocol
  static void OSConfRegDirectRead( HANDLE myOSHandle, UInt32 address, UInt32 &val );
  static void OSConfRegDirectWrite( HANDLE myOSHandle, UInt32 address, UInt32 val );

  // Read/Write value to ISP registers using MemRd/MemWr
  static void OSISPRegRead( HANDLE myOSHandle, UInt32 address, UInt32 &val );
  static void OSISPRegWrite( HANDLE myOSHandle, UInt32 address, UInt32 val );

private:
  CAgtOSPort( void )
  {
  }

  ~CAgtOSPort( void )
  {
  }

  static void OSRegisterReadGen2( HANDLE myOSHandle, UInt32 address, UInt8 size, UInt32 &val );
  static void OSRegisterWriteGen2( HANDLE myOSHandle, UInt32 address, UInt8 size, UInt32 val );
};

// Offsets into PCIE config space of E2960 for PCIEAPI port protocol are here:
#include "devpcieintdefs.h"

#endif